/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist;

import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.internal.contentAssist.ContentAssistUtils;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import com.aptana.editor.php.internal.parser.nodes.PHPClassParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPConstantNode;
import com.aptana.editor.php.internal.parser.nodes.PHPFunctionParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPVariableParseNode;
import com.aptana.editor.php.internal.parser.nodes.Parameter;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContentAssistCollectors {
    public static Set<IElementEntry> collectVariableEntries(IElementsIndex index, String varName, Set<String> types, boolean exactMatch, Map<String, String> aliases, final String namespace) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        String rightVarName = varName.substring(1);
        for (String leftType : types) {
            List<IElementEntry> currentEntries;
            block7: {
                String typeName = ContentAssistCollectors.processTypeName(aliases, namespace, leftType);
                String entryPath = String.valueOf(typeName) + rightVarName;
                currentEntries = null;
                currentEntries = exactMatch ? index.getEntries(3, entryPath) : index.getEntriesStartingWith(3, entryPath);
                List<Object> items = ContentAssistUtils.selectModelElements(leftType, true);
                if (items == null || items.isEmpty()) break block7;
                String lowCaseFuncName = varName != null ? varName.toLowerCase() : "";
                for (Object obj : items) {
                    IParseNode[] children;
                    if (!(obj instanceof PHPClassParseNode)) continue;
                    final PHPClassParseNode classParseNode = (PHPClassParseNode)obj;
                    IParseNode[] iParseNodeArray = children = classParseNode.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block8: {
                            PHPVariableParseNode varParseNode;
                            block9: {
                                IParseNode child = iParseNodeArray[n2];
                                if (!(child instanceof PHPVariableParseNode) || child instanceof PHPConstantNode || !(varParseNode = (PHPVariableParseNode)child).isField()) break block8;
                                String funcNodeName = varParseNode.getNodeName();
                                if (funcNodeName == null) break block9;
                                if (!funcNodeName.startsWith("$")) {
                                    funcNodeName = "$" + funcNodeName;
                                }
                                String lowCaseFuncNodeName = funcNodeName.toLowerCase();
                                if (exactMatch ? !lowCaseFuncName.equals(lowCaseFuncNodeName) : !lowCaseFuncNodeName.startsWith(lowCaseFuncName)) break block8;
                            }
                            result.add(new IElementEntry(){
                                private VariablePHPEntryValue value;

                                @Override
                                public int getCategory() {
                                    return 3;
                                }

                                @Override
                                public String getEntryPath() {
                                    return String.valueOf(classParseNode.getNodeName()) + '/' + varParseNode.getNodeName();
                                }

                                @Override
                                public String getLowerCaseEntryPath() {
                                    String path = this.getEntryPath();
                                    return path != null ? path.toLowerCase() : "";
                                }

                                @Override
                                public IModule getModule() {
                                    return null;
                                }

                                @Override
                                public Object getValue() {
                                    if (this.value != null) {
                                        return this.value;
                                    }
                                    this.value = new VariablePHPEntryValue(varParseNode.getModifiers(), varParseNode.isParameter(), varParseNode.isLocalVariable(), varParseNode.isField(), varParseNode.getNodeType(), varParseNode.getStartingOffset(), namespace);
                                    return this.value;
                                }
                            });
                        }
                        ++n2;
                    }
                }
            }
            if (currentEntries == null) continue;
            result.addAll(currentEntries);
        }
        return result;
    }

    public static Set<IElementEntry> collectConstEntries(IElementsIndex index, String constName, Set<String> types, boolean exactMatch, Map<String, String> aliases, final String namespace) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        String rightConstName = constName;
        for (String leftType : types) {
            List<IElementEntry> currentEntries;
            block5: {
                List<Object> items;
                String typeName = ContentAssistCollectors.processTypeName(aliases, namespace, leftType);
                String entryPath = String.valueOf(typeName) + rightConstName;
                currentEntries = null;
                currentEntries = exactMatch ? index.getEntries(4, entryPath) : index.getEntriesStartingWith(4, entryPath);
                if (currentEntries != null && !currentEntries.isEmpty() || (items = ContentAssistUtils.selectModelElements(leftType, true)) == null || items.isEmpty()) break block5;
                String lowCaseConstName = constName != null ? constName.toLowerCase() : "";
                for (Object obj : items) {
                    IParseNode[] children;
                    if (!(obj instanceof PHPClassParseNode)) continue;
                    final PHPClassParseNode classParseNode = (PHPClassParseNode)obj;
                    IParseNode[] iParseNodeArray = children = classParseNode.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block6: {
                            PHPConstantNode constantNode;
                            block7: {
                                IParseNode child = iParseNodeArray[n2];
                                if (!(child instanceof PHPConstantNode)) break block6;
                                constantNode = (PHPConstantNode)child;
                                String constNodeName = constantNode.getNodeName();
                                if (constNodeName == null) break block7;
                                String lowCaseFuncNodeName = constNodeName.toLowerCase();
                                if (exactMatch ? !lowCaseConstName.equals(lowCaseFuncNodeName) : !lowCaseFuncNodeName.startsWith(lowCaseConstName)) break block6;
                            }
                            result.add(new IElementEntry(){
                                private VariablePHPEntryValue value;

                                @Override
                                public int getCategory() {
                                    return 4;
                                }

                                @Override
                                public String getEntryPath() {
                                    return String.valueOf(classParseNode.getNodeName()) + '/' + constantNode.getNodeName();
                                }

                                @Override
                                public String getLowerCaseEntryPath() {
                                    String path = this.getEntryPath();
                                    return path != null ? path.toLowerCase() : "";
                                }

                                @Override
                                public IModule getModule() {
                                    return null;
                                }

                                @Override
                                public Object getValue() {
                                    if (this.value != null) {
                                        return this.value;
                                    }
                                    this.value = new VariablePHPEntryValue(constantNode.getModifiers(), constantNode.isParameter(), constantNode.isLocalVariable(), constantNode.isField(), constantNode.getNodeType(), constantNode.getStartingOffset(), namespace);
                                    return this.value;
                                }
                            });
                        }
                        ++n2;
                    }
                }
            }
            if (currentEntries == null) continue;
            result.addAll(currentEntries);
        }
        return result;
    }

    private static String processTypeName(Map<String, String> aliases, String namespace, String typeName) {
        String result = typeName;
        if (namespace != null) {
            if (typeName.startsWith(String.valueOf(namespace) + "\\")) {
                String type = typeName.substring(namespace.length() + 1);
                if (aliases.containsValue(type)) {
                    result = type;
                }
            } else if (aliases.containsKey(typeName)) {
                result = aliases.get(typeName);
            } else if (!(aliases.containsValue(typeName) || typeName.contains("\\") || "\\".equals(namespace))) {
                boolean found = false;
                Set<Map.Entry<String, String>> entrySet = aliases.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    String value = entry.getValue();
                    int lastNamesaceDelimiter = value.lastIndexOf("\\");
                    if (lastNamesaceDelimiter <= -1 || lastNamesaceDelimiter >= value.length() - 1 || !typeName.equals(value.substring(lastNamesaceDelimiter + 1))) continue;
                    result = value;
                    found = true;
                    break;
                }
                if (!found) {
                    result = String.valueOf(namespace) + "\\" + typeName;
                }
            }
        }
        return String.valueOf(result) + '/';
    }

    public static Set<IElementEntry> collectFunctionEntries(IElementsIndex index, String funcName, Set<String> types, boolean exactMatch, Map<String, String> aliases, String namespace) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        String rightMethodName = funcName;
        for (String leftType : types) {
            List<IElementEntry> currentEntries;
            block5: {
                List<Object> items;
                String typeName = ContentAssistCollectors.processTypeName(aliases, namespace, leftType);
                String entryPath = String.valueOf(typeName) + rightMethodName;
                currentEntries = null;
                currentEntries = exactMatch ? index.getEntries(2, entryPath) : index.getEntriesStartingWith(2, entryPath);
                if (currentEntries != null && !currentEntries.isEmpty() || (items = ContentAssistUtils.selectModelElements(leftType, true)) == null || items.isEmpty()) break block5;
                String lowCaseFuncName = funcName != null ? funcName.toLowerCase() : "";
                for (Object obj : items) {
                    IParseNode[] children;
                    if (!(obj instanceof PHPClassParseNode)) continue;
                    final PHPClassParseNode classParseNode = (PHPClassParseNode)obj;
                    IParseNode[] iParseNodeArray = children = classParseNode.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block6: {
                            PHPFunctionParseNode functionParseNode;
                            block7: {
                                IParseNode child = iParseNodeArray[n2];
                                if (!(child instanceof PHPFunctionParseNode)) break block6;
                                functionParseNode = (PHPFunctionParseNode)child;
                                String funcNodeName = functionParseNode.getNodeName();
                                if (funcNodeName == null) break block7;
                                String lowCaseFuncNodeName = funcNodeName.toLowerCase();
                                if (exactMatch ? !lowCaseFuncName.equals(lowCaseFuncNodeName) : !lowCaseFuncNodeName.startsWith(lowCaseFuncName)) break block6;
                            }
                            result.add(new IElementEntry(){
                                private FunctionPHPEntryValue value;

                                @Override
                                public int getCategory() {
                                    return 2;
                                }

                                @Override
                                public String getEntryPath() {
                                    return String.valueOf(classParseNode.getNodeName()) + '/' + functionParseNode.getNodeName();
                                }

                                @Override
                                public String getLowerCaseEntryPath() {
                                    String path = this.getEntryPath();
                                    return path != null ? path.toLowerCase() : "";
                                }

                                @Override
                                public IModule getModule() {
                                    return null;
                                }

                                @Override
                                public Object getValue() {
                                    if (this.value != null) {
                                        return this.value;
                                    }
                                    Parameter[] parameters = functionParseNode.getParameters();
                                    LinkedHashMap<String, Set<Object>> parametersMap = null;
                                    boolean[] mandatories = null;
                                    ArrayList<Integer> startPositions = null;
                                    parametersMap = new LinkedHashMap<String, Set<Object>>(parameters.length);
                                    if (parameters != null) {
                                        mandatories = new boolean[parameters.length];
                                        startPositions = new ArrayList<Integer>(parameters.length);
                                        int i = 0;
                                        while (i < parameters.length) {
                                            Parameter parameter = parameters[i];
                                            String nameIdentifier = parameter.getVariableName();
                                            if (nameIdentifier != null) {
                                                if (nameIdentifier.startsWith("$")) {
                                                    nameIdentifier = nameIdentifier.substring(1);
                                                }
                                                String parameterType = parameter.getClassType();
                                                HashSet<String> types = null;
                                                if (parameterType != null) {
                                                    types = new HashSet<String>(1);
                                                    types.add(parameterType);
                                                }
                                                parametersMap.put(nameIdentifier, types);
                                                mandatories[i] = "".equals(parameter.getDefaultValue());
                                                startPositions.add(functionParseNode.getStartingOffset());
                                            }
                                            ++i;
                                        }
                                    }
                                    int[] startPositionsArray = new int[startPositions.size()];
                                    int p = 0;
                                    while (p < startPositions.size()) {
                                        startPositionsArray[p] = (Integer)startPositions.get(p);
                                        ++p;
                                    }
                                    this.value = new FunctionPHPEntryValue(functionParseNode.getModifiers(), true, parametersMap, startPositionsArray, mandatories, functionParseNode.getStartingOffset(), "");
                                    return this.value;
                                }
                            });
                        }
                        ++n2;
                    }
                }
            }
            if (currentEntries == null) continue;
            result.addAll(currentEntries);
        }
        return result;
    }

    public static Set<IElementEntry> collectBuiltinTypeEntries(Set<String> types, boolean exactMatch) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (String typeName : types) {
            List<Object> items = ContentAssistUtils.selectModelElements(typeName, true);
            if (items == null || items.isEmpty()) continue;
            String lowCaseClassName = typeName != null ? typeName.toLowerCase() : "";
            for (Object obj : items) {
                PHPClassParseNode classParseNode;
                String nodeName;
                if (!(obj instanceof PHPClassParseNode) || (nodeName = (classParseNode = (PHPClassParseNode)obj).getNodeName()) == null) continue;
                String lowCaseClassNodeName = nodeName.toLowerCase();
                if (exactMatch ? !lowCaseClassName.equals(lowCaseClassNodeName) : !lowCaseClassNodeName.startsWith(lowCaseClassName)) continue;
                result.add(new IElementEntry(){
                    private ClassPHPEntryValue value;

                    @Override
                    public int getCategory() {
                        return 1;
                    }

                    @Override
                    public String getEntryPath() {
                        return classParseNode.getNodeName();
                    }

                    @Override
                    public String getLowerCaseEntryPath() {
                        String path = this.getEntryPath();
                        return path != null ? path.toLowerCase() : "";
                    }

                    @Override
                    public IModule getModule() {
                        return null;
                    }

                    @Override
                    public Object getValue() {
                        if (this.value != null) {
                            return this.value;
                        }
                        String superClassname = classParseNode.getSuperClassname();
                        List<String> interfaces = classParseNode.getInterfaces();
                        this.value = new ClassPHPEntryValue(classParseNode.getModifiers(), superClassname, interfaces, "");
                        return this.value;
                    }
                });
            }
        }
        return result;
    }
}

